@if ($paginator->hasPages())
    <ul class="mt-10 page-nav list-style">
        {{-- Previous Page Link --}}
        @if ($paginator->onFirstPage())
            <li><a href="#"><i class="ri-arrow-left-s-line"></i></a></li>
        @else
            <li><a href="{{ $paginator->previousPageUrl() }}"><i class="ri-arrow-left-s-line"></i></a></li>
        @endif

        @foreach ($elements as $element)
            {{-- "Three Dots" Separator --}}
            @if (is_string($element))
                <li class="disabled"><a href="#">{{$element}}</a></li>
            @endif

            {{-- Array Of Links --}}
            @if (is_array($element))
                @foreach ($element as $page => $url)
                    @if ($page == $paginator->currentPage())
                        <li><a class="active" href="{{$url}}">{{$page}}</a></li>
                    @else
                        <li><a href="{{ $url }}">{{ $page }}</a></li>
                    @endif
                @endforeach
            @endif
        @endforeach

        @if ($paginator->hasMorePages())
                <li><a href="{{ $paginator->nextPageUrl() }}"><i class="ri-arrow-right-s-line"></i></a></li>
            @else
                <li disabled><a href="#"><i class="ri-arrow-right-s-line"></i></a></li>
        @endif
    </ul>
@endif

