<x-modal id="{{$id}}" class="modal-xl">

    {{-- <x-slot:header></x-slot:header> --}}

    <div>
        <div class="row">
            <div class="col-md-5 h-100 bg-primary"></div>
            <div class="p-5 col-md-7">
                <form wire:submit='createRateAlert' class="d-flex flex-column">
                    <div class="text-center mb-3">
                        <h3>Track the currency exchange rate</h3>
                    </div>

                    <p class="text-success">{{$success}}</p>

                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="country_from">From Currency</label>
                                <select wire:model='from' id="country_from">
                                    @forelse ($currencies->isActive()->get() as $currency)
                                        <option value="{{$currency->symbol}}">{{$currency->symbol}} - {{$currency->name}}</option>
                                    @empty
                                    @endforelse
                                </select>
                                <x-input.error key="from" />
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="currency_to">To Currency</label>
                                <select wire:model='to' id="country_to">
                                    @forelse ($currencies->isActive()->get() as $currency)
                                    <option value="{{$currency->symbol}}">{{$currency->symbol}} - {{$currency->name}}</option>
                                    @empty
                                    @endforelse
                                </select>
                                <x-input.error key="to" />
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="form-label">Name</label>
                        <input type="text" wire:model="name" class="form-control" placeholder="Name">
                        <x-input.error key="name" />
                    </div>

                    <div class="form-group">
                        <label class="form-label">Email Address</label>
                        <input type="text" wire:model="email" class="form-control" placeholder="Email Address">
                        <x-input.error key="email" />
                    </div>

                    <div class="form-group">
                        <label class="form-label">Frequency</label>
                        <select wire:model="frequency" id="" class="form-select">
                            <option >Daily</option>
                            <option >Weekly</option>
                        </select>
                        <x-input.error key="frequency" />
                    </div>

                    <div>
                        <button type="submit" class="btn style1 w-100">Subscribe <x-spinner wire:loading wire:trigger='createRateAlert' /></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-modal>
