<div class="content-wrapper">
    @forelse ($adverts->where('position', 'below_top_menu_bar')->get() as $advert)
        <div class="feature-wrap style1 py-3 bg-whisper">
            {!! $advert->content !!}
        </div>
    @empty
    @endforelse

    <div class="breadcrumb-wrap bg-f br-1">
        <div class="container">
            <div class="breadcrumb-title">
                <h2>Contact Us</h2>
                <ul class="breadcrumb-menu list-style">
                    <li><a href="{{route('home')}}">Home </a></li>
                    <li>Contact Us</li>
                </ul>
            </div>
        </div>
    </div>


    <section class="contact-us-wrap ptb-100">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-4 col-lg-6 col-md-6">
                    <div class="contact-item">
                        <span class="contact-icon">
                            <i class="ri-map-pin-line"></i>
                        </span>
                        <div class="contact-info">
                            <h3>Our Location</h3>
                            <p>{{$setting->contact_address->value}}</p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-6 col-md-6">
                    <div class="contact-item">
                        <span class="contact-icon">
                            <i class="ri-mail-send-line"></i>
                        </span>
                        <div class="contact-info">
                            <h3>Email Us</h3>
                            <a href="mailto:{{$setting->site_email->value}}">
                                <span class="__cf_email__" >{{$setting->site_email->value}}</span>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-6 col-md-6">
                    <div class="contact-item">
                        <span class="contact-icon">
                            <i class="ri-phone-line"></i>
                        </span>
                        <div class="contact-info">
                            <h3>Phone</h3>
                            <a href="tel:{{$setting->contact_phone->value}}">{{$setting->contact_phone->value}}</a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-7">
                    <div class="contact-form">
                        <form class="form-wrap" action="{{route('contact.send')}}" id="contactForm" >
                            @if (session('error') || session('success'))
                                <div class="py-3">
                                    @if (session('error'))
                                        <p class="text-danger">{{session()->get('success')}}</p>
                                    @endif
                                    @if (session('success'))
                                        <p class="text-success">{{session()->get('success')}}</p>
                                    @endif
                                </div>
                            @endif
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="text" name="name" placeholder="Name*" id="name" required >
                                        <x-input.error key="name" />
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <input type="email" name="email" id="email" required placeholder="Email*">
                                        <x-input.error key="name" />
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <input type="text" name="subject" placeholder="Subject*" id="msg_subject" required data-error="Please enter your subject" />
                                            <x-input.error key="name" />
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group v1">
                                        <textarea name="message" id="message" placeholder="Your Messages.."
                                            cols="30" rows="10" required
                                            data-error="Please enter your message"></textarea>
                                        <div class="help-block with-errors"></div>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <button type="submit" class="btn style1">SEND MESSAGE<i
                                            class="ri-arrow-right-s-line"></i>
                                    </button>
                                    <div class="clearfix"></div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-lg-5">
                    <div class="comp-map">
                        <iframe
                            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3151.8385385572983!2d144.95358331584498!3d-37.81725074201705!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x6ad65d4dd5a05d97%3A0x3e64f855a564844d!2s121%20King%20St%2C%20Melbourne%20VIC%203000%2C%20Australia!5e0!3m2!1sen!2sbd!4v1612419490850!5m2!1sen!2sbd">
                        </iframe>
                    </div>
                </div>
            </div>
        </div>
    </section>

</div>
