<div class="content-wrapper">
    @forelse ($adverts->where('position', 'below_top_menu_bar')->get() as $advert)
        <div class="feature-wrap style1 py-3 bg-whisper">
            {!! $advert->content !!}
        </div>
    @empty
    @endforelse

    <section class="convert-wrap ptb-100">
        <div class="container">
            <div class="mb-5">
                <div class="col-md-8 mx-auto">
                    <div class="mb-40 text-center section-title style1">
                        <span>BUY AND SELL GIFTCARDS</span>
                        <h2>Get the best deals on gift cards sale and purchase from all over the world.</h2>
                    </div>
                </div>
            </div>
            <div class="convert-box">
                <div class="convert-tabcontent">
                    <form wire:submit='purchase'>
                        <div class="row g-5">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Name</label>
                                    <input type="text" wire:model="name" class="form-control" placeholder="Name">
                                    <x-input.error key="name" />
                                </div>
                    
                                <div class="form-group">
                                    <label class="form-label">Email Address</label>
                                    <input type="text" wire:model="email" class="form-control" placeholder="Email Address">
                                    <x-input.error key="email" />
                                </div>

                                <div class="form-group">
                                    <label class="form-label">WhatsApp Number</label>
                                    <input type="tel" wire:model="phone" class="form-control" placeholder="WhatsApp Phone Number">
                                    <x-input.error key="phone" />
                                </div>

                                <div class="form-group">
                                    <label class="form-label">What do you want to do?</label>

                                    <div class="d-flex gap-3">
                                        <div class="checkbox style3 mb-0">
                                            <input type="radio" wire:model='type' name="type" value='buy' id="buy">
                                            <label for="buy">I want to buy</label>
                                        </div>

                                        <div class="checkbox style3 mb-0">
                                            <input type="radio" wire:model='type' name="type" value='sell' id="sell">
                                            <label for="sell">I want to sell</label>
                                        </div>
                                    </div>

                                    <x-input.error key="type" />
                                </div>
                                
                                <div class="row row-cols-2">
                                    <div class="form-group">
                                        <label class="form-label">Select Gift Card</label>
                                        <select wire:model='product' class="form-select form-control" >
                                            @forelse ($products as $product)
                                                <option value="{{$product->id}}">{{$product->name}}</option>                                        
                                            @empty
                                            @endforelse
                                        </select>
                                        <x-input.error key="product" />
                                    </div>
                                    
                                    <div class="form-group">
                                        <label class="form-label">Amount ($)</label>
                                        <input wire:model='amount'  />
                                        <x-input.error key="amount" />
                                    </div>
                                </div>

                    
                                <div class="form-group">
                                    <button type="submit" class="btn style1 w-100">Buy Gift Card <x-spinner wire:loading wire:trigger='purchase' /></button>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="alert-content">
                                    <h5 class="fw-bold">Available Gift cards</h5>
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>Gift Card</th>
                                                <th>We Buy ($)</th>
                                                <th>We Sell ($)</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse ($products as $product)
                                                <tr>
                                                    <th>{{$product->name}}</th>
                                                    <th>${{number_format($product->buy_price)}}</th>
                                                    <th>${{number_format($product->sell_price)}}</th>
                                                </tr>
                                            @empty
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
</div>

