<div class="content-wrapper">
    @push('meta')
        <meta name="description" content="{{$category->meta_description}}">
        <meta property="og:image"  content="{{$category->image}}">
        <meta name="twitter:image" content="{{$category->image}}">

        <meta name='description'         content='{{$category->meta_description}}'>
        <meta property='og:description'  content='{{$category->meta_description}}'>
        <meta name='twitter:description' content='{{$category->meta_description}}'>

        <meta property='og:title'  content='{{$category->name}}'>
        <meta name='twitter:title' content='{{$category->name}}'>
    @endpush

    @forelse ($adverts->where('position', 'below_top_menu_bar')->get() as $advert)
        <div class="feature-wrap style1 pt-100 pb-75 bg-whisper">
            {!! $advert->content !!}
        </div>
    @empty
    @endforelse


    <div class="feature-wrap style1 pt-100 pb-75 bg-whisper">
        <div class="container">
            <div class="row">
                <div class="col-md-8 mx-auto">
                    <div class="section-title style1 text-center mb-40">
                        <h1 style="font-size: 40px;
                        line-height: 1.5;">{{$category->name}}</h1>
                        <span style="font-size: 18px; letter-spacing: normal;line-height: 1.5rem;">{{$category->description}}</span>
                    </div>
                </div>
            </div>

            <div class="row justify-content-center">
                @forelse ($categories as $categoryItem)
                    <div class="col-md-3 cols-6">
                        @include('livewire.blog.partials.category-item', ['category' => $categoryItem])
                    </div>
                @empty
                @endforelse
            </div>
        </div>
    </div>

    <div class="blog-wrap pb-100">
        <div class="container">
            @if ($featuredPosts->count())
                <div class="mb-4 text-center">
                    <h3 class="mb-0">Featured Posts</h3>
                    {{-- <p>Here are our top financial insights and currency updates</p> --}}
                </div>

                <div class="row row-cols-md-3">
                    @forelse ($featuredPosts as $post)
                        <div>
                            @include('livewire.blog.partials.blog-list-item')
                        </div>
                    @empty
                    @endforelse
                </div>
            @endif
        </div>
    </div>

    <div class="blog-wrap pb-100">
        <div class="container">
            <div class="mb-4 text-center pb-50">
                <h3 class="mb-0">Latest from {{$category->name}}</h3>
                {{-- <p>Here are latest posts on financial insights and currency updates</p> --}}
            </div>
            <div class="row row-cols-md-3 g-5 mb-5">
                @forelse ($posts as $post)
                    @include('livewire.blog.partials.blog-list-item')
                @empty
                @endforelse
            </div>


            {{$posts->onEachSide(2)->links('partials.paginator')}}
        </div>
    </div>

</div>
