<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    @include('layouts.partials.styles')

    <link rel="shortcut icon" href="{{asset('favicon.png')}}" type="image/x-icon">
    <title>{{$title ?? ''}} - {{env('APP_NAME')}}</title>
    <meta name="keywords" content="monieroar nigerian currency to dollar, aboki dollar to naira today, dollar to naira bank rate today, dollar exchange rate today, foreign exchange rate today, dollar exchange rate, usd exchange rate, Currency Exchange Rate, gift cards, cryptocurrency, receive money from abroad" />
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    {!! $setting->header_scripts->value !!}
    <link rel="canonical" href="{{request()->url()}}" />

    @stack('meta')
</head>

<body>
    <div class="switch-theme-mode">
        <label id="switch" class="switch">
            <input type="checkbox" onchange="toggleTheme()" id="slider">
            <span class="slider round"></span>
        </label>
    </div>

    <div class="page-wrapper">
        @include('layouts.partials.header')

        {{$slot}}

        @include('layouts.partials.footer')
    </div>

    @include('layouts.partials.scripts')

    {!! $setting->footer_scripts->value !!}
</body>

</html>
