<x-dynamic-component
    :component="$getFieldWrapperView()"
    :field="$field"
>

    @assets
        <link rel="stylesheet" href="{{asset('vendor/laraberg/css/laraberg.css')}}">
        <script src="https://unpkg.com/react@17.0.2/umd/react.production.min.js"></script>
        <script src="https://unpkg.com/react-dom@17.0.2/umd/react-dom.production.min.js"></script>
        <script src="{{ asset('vendor/laraberg/js/laraberg.js') }}"></script>
    @endassets

    <div wire:ignore x-data="{
        state: $wire.$entangle('{{ $getStatePath() }}'),
    }"
    >
        <textarea id="laraberg-editor" x-on:change="state = $event.target.value" hidden>{{$getRecord()->content ?? ''}}</textarea>
    </div>
    
    @push('script')
        @script
            <script>
                Laraberg.init('laraberg-editor', {
                    mediaUpload: ({filesList, onFileChange}) => {
                        setTimeout(async () => {
                            let formD = new FormData;
                            Array.from(filesList).map(file => {
                                formD.append('upload', file);
                            });

                            const res = await fetch(`{{route('files.upload')}}`, {
                              method: 'POST',
                              body: formD
                            })

                            const uploadedResponse = await res.json()

                            if(!uploadedResponse){
                               return console.log('Error')
                            }

                            const uploadedFiles = Array.from(filesList).map(file => {

                                return {
                                    id: new Date().getTime(),
                                    name: file.name,
                                    url: uploadedResponse.url
                                }
                            })

                            onFileChange(uploadedFiles)
                        }, 500);
                    },
                    imageEditing: true,
                    // fetchHandler: FetchHandler;
                })
            </script>
        @endscript
    @endPush
</x-dynamic-component>
