@props([
    'header',
    'footer',
    'body',
    'id',
    'class'
])

<div class="modal fade" tabindex="-1" role="dialog" wire:ignore.self id="{{$id}}">
    <div class="modal-dialog modal-dialog-centered {{$class ?? ''}}" role="document">
        <div class="modal-content">
            @isset($header)
                <div {{$header->attributes->class(['d-flex justify-content-between py-5'])}}>
                    <div>
                        {{$header}}
                    </div>

                    <div>
                        <button class="btn btn-icon btn-sm" type="button" data-bs-dismiss="modal">
                            <i class=" fs-2x">x</i>
                        </button>
                    </div>
                </div>
            @endisset


            @isset($body)
                <div {{$body->attributes->class(['text-left'])}}>
                    {{$body}}
                </div>
            @else
                <div class="modal-body text-left">
                    {{$slot}}
                </div>
            @endisset


            @isset($footer)
                <div {{$footer->attributes->class(['modal-footer'])}}>
                    {{$footer}}
                </div>
            @endisset
        </div>
    </div>
</div>
