<?php

namespace App\Providers;

use App\Models\Advert;
use App\Models\Category;
use App\Models\Currency;
use App\Models\Page;
use App\Models\Setting;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void {

        View::share([
            'currencies' => new Currency(),
            'categories' => new Category(),
            'setting' => new Setting(),
            'pages' => new Page(),
            'adverts' => new Advert() 
        ]);

    }
}
