<?php

namespace App\Models;

use App\Enums\Status;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use VanOns\Laraberg\Traits\RendersContent;

class Blog extends Model
{
    use HasFactory, HasUuids, SoftDeletes, RendersContent;

    protected $fillable = ['title', 'content', 'tags', 'description', 'visits', 'unique_visits', 'category_id', 'slug', 'image', 'status', 'author_id', 'published_at', 'is_featured'];

    protected $with = ['category'];

    protected $casts = [
        'tags' => 'array',
        'status' => Status::class
    ];

    protected $attributes = [
        'visits' => 0,
        'unique_visits' => 0,
        'status' => Status::PENDING
    ];

    function category(){
        return $this->belongsTo(Category::class, 'category_id');
    }

    function author(){
        return $this->belongsTo(User::class, 'author_id');
    }

    function scopeIsPublished(Builder $query) {
        $this->where('status', Status::PUBLISHED);
    }

    // Attributes
    function getRouteAttribute(){
        return route('blog.details', [
            'blog' => $this->slug
        ]);
    }

    function getFeaturedImageAttribute(){
        return asset('storage/'.$this->image);
    }

}
