<?php

namespace App\Library;

use App\Models\Advert;
use App\Models\Currency;

class Functions {

    function templates(){
        $currency = Currency::find(session('currency'));
        $adverts = Advert::where('position', 'inside_blog_post')->get()->pluck('content','shortcode');
        
        return [
            'currency_name' => $currency?->name ?? 'United States',
            'currency_symbol' => $currency?->symbol ?? 'USD',
            'country' => session('country'),
            'current_date' => now()->format('jS F, Y'),
            'current_day' => now()->weekday(),
            'current_year' => now()->year(),
            'current_month' => now()->month(),
            'current_time' => now()->format('h:m A'),
            ...$adverts
        ];
    }

    function context(){
        $items = array_keys((new Functions)->templates());
        $filtered = array_map(fn($item) => "{{{$item}}}", $items);
        return implode(' , ', $filtered);
    }

}