<?php

namespace App\Console\Commands;

use App\Models\Currency;
use App\Services\ExchangeService;
use Illuminate\Console\Command;

class SeedCurrencies extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'seed:currencies';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $exchange = new ExchangeService();
        [$status, $currencies] = $exchange->currencies();
        if($status){
            foreach ($currencies as $key => $value) {
                Currency::create([
                    'symbol' => $key,
                    'name' => $value
                ]);
            }
        }
    }
}
