<x-guest-layout :title="$setting->site_title->value">
    @push('meta')
        <meta name="keywords" content="nigerian currency to dollar, aboki dollar to naira today, dollar to naira bank rate today, dollar exchange rate today, foreign exchange rate today, dollar exchange rate, usd exchange rate, Currency Exchange Rate, gift cards, cryptocurrency, receive money from abroad" />
        <meta name="description" content="{{env('APP_NAME')}} is your go-to for dollar to naira today black market rate, foreign exchange, gift cards, and cryptocurrency. Receive money from abroad easily and securely." />
    @endpush
    
    <div class="content-wrapper">

        <section class="convert-wrap ptb-100">
            <div class="container">
                <div class="col-md-8 mx-auto">
                    <div class="mb-40 text-center section-title style1">
                        <span style="letter-spacing: normal;" class="fs-5">Your best source for tracking currency rates and cryptocurrency and gift cards trading platform.</span>
                        <h1>The most reliable currency converter</h1>
                    </div>
                </div>

                <x-convert type="converter" />
            </div>
        </section>


        <div class="feature-wrap style1 pt-100 pb-75 bg-whisper">
            <div class="container">
                <div class="row">
                    <div class="col-xl-6 offset-xl-3 col-lg-10 offset-lg-1">
                        <div class="mb-40 text-center section-title style1">
                            <h2>Get alerts on your favorite currency update</h2>
                        </div>
                    </div>
                </div>
                <div class="row justify-content-center">
                    <div class=" col-xxl-4 col-xl-4 col-lg-6 col-md-6">
                        <div class="feature-card style1">
                            <div class="feature-icon">
                                <i class="flaticon-pie-chart"></i>
                            </div>
                            <h3><a href="{{route('convert')}}">Effortless Currency Conversions Made Simple!</a></h3>
                            <p>Effortlessly convert currencies with our intuitive tool. Instantly calculate real-time rates for seamless global transactions.</p>
                            <a href="{{route('convert')}}" class="link style1">Convert Currency<i
                                    class="ri-arrow-right-s-line"></i></a>
                        </div>
                    </div>
                    <div class=" col-xxl-4 col-xl-4 col-lg-6 col-md-6">
                        <div class="feature-card style1">
                            <div class="feature-icon">
                                <i class="flaticon-notification"></i>
                            </div>
                            <h3><a href="{{route('rate-alerts')}}">Stay Updated with Custom Rate Alerts!</a></h3>
                            <p>Set custom rate alerts using our converter tool. Get notified instantly when rates hit your target, enabling timely currency conversions.</p>
                            <a href="{{route('rate-alerts')}}" class="link style1">Create Alerts<i
                                    class="ri-arrow-right-s-line"></i></a>
                        </div>
                    </div>
                    <div class=" col-xxl-4 col-xl-4 col-lg-6 col-md-6">
                        <div class="feature-card style1">
                            <div class="feature-icon">
                                <i class="flaticon-user-3"></i>
                            </div>
                            <h3><a href="{{route('blog')}}">Access Real-Time Currency Rates</a></h3>
                            <p>Access real-time exchange rates and historical data for informed financial decisions. Explore currency trends and conversions effortlessly!</p>
                            <a href="{{route('blog')}}" class="link style1">Visit Blog <i
                                    class="ri-arrow-right-s-line"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @forelse ($adverts->where('position', 'home_page_middle')->get() as $advert)
            <div class="feature-wrap style1 pt-100 pb-75 bg-whisper">
                {!! $advert->content !!}
            </div>
        @empty
        @endforelse

        @if ($categories->count() > 0)
            <div class="blog-wrap ptb-100">
                <div class="container">
                    <div class="mb-4">
                        <div class="row justify-content-center">
                            @forelse ($categories as $category)
                                <div class="col-md-3 cols-6">
                                    @include('livewire.blog.partials.category-item')
                                </div>
                            @empty
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>
        @endif

        @if ($recentPosts->count() > 0)
            <div class="blog-wrap ptb-100">
                <div class="container">
                    <div class="mb-4">
                        <h3 class="mb-0">Latest Posts</h3>
                        <p>Here are latest posts on financial insights and currency updates</p>
                    </div>

                    <div>
                        <div class="row row-cols-md-3 g-5">
                            @forelse ($recentPosts as $post)
                                <div>
                                    @include('livewire.blog.partials.blog-item', ['category' => $post->category])
                                </div>
                            @empty
                            @endforelse   
                        </div>
                    </div>
        
                    <div class="text-center">
                        <a href="{{route('blog')}}">
                            <button  class="btn style1">Load More</button>
                        </a>
                    </div>
                </div>
            </div>
        @endif
        
    </div>
</x-guest-layout>
