<section class="exchange-table-wrap pb-100">
    <div class="container">
        <div class="row">
            <div class="col-xl-6 offset-xl-3 col-lg-8 offset-lg-2">
                <div class="mb-40 text-center section-title style1">
                    <span>LIVE EXCHANGE RATES</span>
                    <h2>Exchange Money Across The World In Real Time With Lowest Fees</h2>
                </div>
            </div>
        </div>
        <div class="exchange-table">
            <table class="table">
                <thead>
                    <tr>
                        <th scope="col">Currency</th>
                        <th scope="col">Amount</th>
                        <th scope="col">Change(24h)</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($displayRates as $key => $rate)
                        <tr>
                            <td>
                                <div class="country-flag">
                                    {{$currencies->where('symbol', $key)->first()->name}}
                                </div>
                            </td>
                            <td>
                                {{$key}} {{number_format($rate['today'], 3, '.')}}
                            </td>
                            <td>
                                @if ($rate['today'] > $rate['yesterday'])
                                    <span class="text-green">
                                        +{{number_format($rate['percent'], 2, '.')}}%
                                    </span>
                                @elseif ($rate['percent'] == 0)
                                    <span>{{$rate['percent']}}%</span>
                                @else
                                    <span class="text-red">
                                        -{{number_format($rate['percent'], 2, '.')}}%
                                    </span>
                                @endif
                            </td>
                        </tr>
                    @empty

                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="row align-items-center">
            <div class="col-sm-6">
                {{-- <button type="button" class="add-currency"><span><i
                            class="ri-add-circle-line"></i></span>Add Currency</button> --}}
            </div>
            <div class="col-sm-6 text-sm-end">
                <p class="update-status">Last Updated {{now()->format('M j, Y')}}</p>
            </div>
        </div>
    </div>
</section>
