<div>
    <div class="content-wrapper">
        @forelse ($adverts->where('position', 'below_top_menu_bar')->get() as $advert)
            <div class="py-3 feature-wrap style1 bg-whisper">
                {!! $advert->content !!}
            </div>
        @empty
        @endforelse

        <div class="breadcrumb-wrap bg-f br-1">
            <div class="container">
                <div class="breadcrumb-title">
                    <h2>Currency Chart</h2>
                    <ul class="breadcrumb-menu list-style">
                        <li><a href="{{ route('home') }}">Home </a></li>
                        <li>Currency Chart</li>
                    </ul>
                </div>
            </div>
        </div>

        <section class="convert-wrap ptb-100">
            <div class="container">
                <div class="row">
                    <div class="col-xl-6 offset-xl-3 col-lg-8 offset-lg-2">
                        <div class="mb-40 text-center section-title style1">
                            <span>CURRENCY CONVERTER</span>
                            {{-- <h2>The Relaible, Cheap, &amp; Fastest Way To Send Money Abroad</h2> --}}
                        </div>
                    </div>
                </div>

                <div class="convert-box">
                    <ul class="convert-tablist list-style" role="tablist" style="background: #f9f9f9;">
                        <li class="nav-item">
                            <a class="active" href="{{ route('convert') }}"><i
                                    class="ri-exchange-dollar-line"></i>Convert</a>
                        </li>

                        <li class="nav-item">
                            <a href="{{ route('rate-alerts') }}">
                                <i class="ri-notification-3-line"></i>Alerts
                            </a>
                        </li>
                    </ul>
                    <div class="convert-tabcontent">
                        <form wire:submit='exchange' class="convert-form " style="position: relative;">
                            <div class="row">
                                <div class="col-lg-3">
                                    <div class="form-group">
                                        <label for="currency">I'd Like To Exchange </label>
                                        <div class="" style="position: relative;">
                                            <span class="h-100 d-flex justify-content-center align-items-center"
                                                style="position: absolute; padding-left: 10px;">{{ $from }}</span>
                                            <x-input.currency :currency="$from" value="{{ $amount }}"
                                                wire:model.blur='amount' style="padding-left: 50px;" id="currency"
                                                name="currency" />
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <label for="country_from">Country From</label>
                                        <select name="from" wire:model.blur='from' id="from">
                                            @forelse ($currencies as $currency)
                                                <option value="{{ $currency->symbol }}">{{ $currency->symbol }} -
                                                    {{ $currency->name }}</option>
                                            @empty
                                            @endforelse
                                        </select>
                                    </div>
                                </div>
                                <div class="text-center col-lg-1 d-flex justify-content-center">
                                    <span class="convert-icon" role="button" wire:click='swap'
                                        style="display: flex; align-items: center; justify-content: center;">
                                        <i class="ri-arrow-left-right-line"></i>
                                    </span>
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <label for="currency_to">Country To</label>
                                        <select name="to" wire:model.blur='to' id="to">
                                            @forelse ($currencies as $currency)
                                                <option value="{{ $currency->symbol }}">{{ $currency->symbol }} -
                                                    {{ $currency->name }}</option>
                                            @empty
                                            @endforelse
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="mt-20 row align-items-center">
                                @if ($result)
                                    <div class="mb-20">
                                        <strong>{{ $amount }} {{ $fromCurrency->name }} =</strong>
                                        <h2>{{ number_format($result, 3, '.') }} {{ $toCurrency->name }}</h2>
                                        <p class="mb-0">1 {{ $from }} = {{ number_format($rate, 3, '.') }}
                                            {{ $to }}</p>
                                        <p>1 {{ $to }} = {{ number_format(1 / $rate, 3, '.') }}
                                            {{ $from }}</p>
                                    </div>
                                @endif
                                <div class="col-xl-6 col-lg-8">
                                    <div class="converter-alert-text">
                                        <i class="ri-error-warning-line"></i>
                                        <small>We use mid-market rate for our converter. This is for international
                                            purpose only.</small>
                                    </div>
                                </div>

                                <div class="col-xl-6 col-lg-4 text-lg-end">
                                    <button class="btn style1"> CONVERT <i class="ri-arrow-right-s-line"></i> <x-spinner
                                            wire:loading wire:target="exchange" /></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </section>

        <section class="convert-wrap pb-100">
            <div class="container">
                <div class="mx-auto col-md-10">
                    <div class="row g-5">
                        <div class="col-md-6">
                            @if ($base)
                                <div class="text-center convert-box">
                                    <div style="color: #0D47A1" class="p-3 bg-light ">
                                        <h5 class="mb-2">Convert {{ $base['symbol'] }} to {{ $target['symbol'] }}
                                        </h5>

                                        <div class="row">
                                            <div class="col-6 fs-6 fw-bold">{{ $base['name'] }}</div>
                                            <div class="col-6 fs-6 fw-bold">{{ $target['name'] }}</div>
                                        </div>
                                    </div>

                                    <div class="text-center">
                                        <div class="p-3">
                                            @forelse ($targetToBase as $value)
                                                <div class="py-2 row">
                                                    <div class="col-6">
                                                        <a href="{{route('convert', ['from' =>  $base['symbol'], 'to' => $target['symbol'],'amount' => $value['step']])}}">
                                                            {{ number_format($value['step']) }}
                                                            {{ $base['symbol'] }}
                                                        </a>
                                                    </div>
                                                    <div class="col-6">{{ number_format($value['amount'], 3, '.') }}
                                                        {{ $target['symbol'] }}</div>
                                                </div>
                                            @empty
                                            @endforelse
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                        <div class="col-md-6">
                            @if ($target)
                                <div class="text-center convert-box">
                                    <div style="color: #0D47A1" class="p-3 bg-light ">
                                        <h5 class="mb-2">Convert {{ $target['symbol'] }} to {{ $base['symbol'] }}
                                        </h5>

                                        <div class="row">
                                            <div class="col-6 fs-6 fw-bold">{{ $target['name'] }}</div>
                                            <div class="col-6 fs-6 fw-bold">{{ $base['name'] }}</div>
                                        </div>
                                    </div>

                                    <div class="text-center">
                                        <div class="p-3">
                                            @forelse ($baseToTarget as $value)
                                                <div class="py-2 row">
                                                    <div class="col-6">
                                                        <a href="{{route('convert', ['from' =>  $target['symbol'], 'to' => $base['symbol'],'amount' => $value['step']])}}">
                                                            {{ number_format($value['step']) }}
                                                            {{ $target['symbol'] }}
                                                        </a>
                                                    </div>
                                                    <div class="col-6">{{ number_format($value['amount'], 3, '.') }}
                                                        {{ $base['symbol'] }}</div>
                                                </div>
                                            @empty
                                            @endforelse
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </section>

        {{-- <livewire:exchange.currency-rates /> --}}
        <section class="exchange-table-wrap ptb-50">
            <div class="container">
                <div class="row">
                    <div class="col-xl-6 offset-xl-3 col-lg-8 offset-lg-2">
                        <div class="mb-40 text-center section-title style1">
                            <span>LIVE EXCHANGE RATES</span>
                        </div>
                    </div>
                </div>
                <div class="exchange-table">
                    <table class="table">
                        <thead>
                            <tr>
                                <th scope="col">Currency</th>
                                <th scope="col">Amount</th>
                                <th scope="col">Change(24h)</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($displayRates as $key => $rate)
                                <tr>
                                    <td>
                                        <div class="country-flag">
                                            {{$currencies->where('symbol', $key)->first()->name}}
                                        </div>
                                    </td>
                                    <td>
                                        {{$key}} {{number_format($rate['today'], 3, '.')}}
                                    </td>
                                    <td>
                                        @if ($rate['today'] > $rate['yesterday'])
                                            <span class="text-success">
                                                +{{number_format($rate['percent'], 2, '.')}}%
                                            </span>
                                        @elseif ($rate['percent'] == 0)
                                            <span>{{$rate['percent']}}%</span>
                                        @else
                                            <span class="text-red">
                                                -{{number_format($rate['percent'], 2, '.')}}%
                                            </span>
                                        @endif
                                    </td>
                                </tr>
                            @empty

                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="row align-items-center">
                    <div class="col-sm-6">
                        {{-- <button type="button" class="add-currency"><span><i
                                    class="ri-add-circle-line"></i></span>Add Currency</button> --}}
                    </div>
                    <div class="col-sm-6 text-sm-end">
                        <p class="update-status">Last Updated {{now()->format('M j, Y')}}</p>
                    </div>
                </div>
            </div>
        </section>


        {{-- <section class="exchange-table-wrap pb-75">
            <div class="container">
                <div class="row gx-5">
                    <div class="col-lg-6">

                    </div>
                    <div class="col-lg-6">
                        <div class="text-center section-title style1 mb-25">
                            <h2>Central Bank Rates</h2>
                        </div>
                        <div class="exchange-table style2">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th scope="col">Currency</th>
                                        <th scope="col">Interest Rate</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            JPY
                                        </td>
                                        <td>
                                            -0.20%
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            CHF
                                        </td>
                                        <td>
                                            -0.30%
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Eur
                                        </td>
                                        <td>
                                            0.70%
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            USD
                                        </td>
                                        <td>
                                            0.32%
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            CAD
                                        </td>
                                        <td>
                                            0.54%
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            AUD
                                        </td>
                                        <td>
                                            0.21%
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            NZD
                                        </td>
                                        <td>
                                            0.43%
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            GBP
                                        </td>
                                        <td>
                                            0.78%
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section> --}}

    </div>

</div>
