<?php

namespace Database\Seeders;

use App\Enums\Roles;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void {
        $email = env('DEFAULT_ADMIN_EMAIL');
        if(!User::isSuperAdmin()->exists()){
            User::create([
                'firstname' => 'Super',
                'lastname' => 'Admin',
                'email' => $email,
                'role' => Roles::SUPERADMIN,
                'password' => Hash::make('1234567890')
            ]);

            User::create([
                'firstname' => 'First',
                'lastname' => 'Admin',
                'email' => 'testadmin@localhost.com',
                'role' => Roles::ADMIN,
                'password' => Hash::make('1234567890')
            ]);

            User::create([
                'firstname' => 'First',
                'lastname' => 'Writer',
                'email' => 'writer@localhost.com',
                'role' => Roles::WRITER,
                'password' => Hash::make('1234567890')
            ]);

            User::create([
                'firstname' => 'First',
                'lastname' => 'Editor',
                'email' => 'editor@localhost.com',
                'role' => Roles::EDITOR,
                'password' => Hash::make('1234567890')
            ]);
        }
    }
}
