<?php

use App\Services\Notify;
use Illuminate\Http\File;
use Illuminate\Http\UploadedFile;
use Intervention\Image\ImageManager;
use Intervention\Image\ImageManagerStatic;

if(!function_exists('percentageDifference')) {
    function percentageDifference($oldValue, $newValue) {
        // Calculate the difference between the two values
        $difference = $newValue - $oldValue;

        // Calculate the percentage difference
        $percentageDifference = ($difference / abs($oldValue)) * 100;

        return $percentageDifference;
    }
}

if(!function_exists('notify')){
    function notify($subject = ''){
        return new Notify($subject);
    }
}

if(!function_exists('upload')) {
    function upload($file, $name, $folder = 'uploads'){
        if(is_array($file)){
            $files = [];

            for($i=0; $i < count($file); $i++) {
                $files[] = handleUpload($file[$i], $name.'-'.$i, $folder);
            }

            return $files;
        }

        return handleUpload($file, $name, $folder);
    }

    function handleUpload($file, $name, $folder = 'uploads'){
        $ext = $file->getClientOriginalExtension();
        $basePath = $folder.'/'.$name.'avif';

        $image = ImageManagerStatic::make($file);

        if($ext !== 'avif') {
            $image->encode('avif');
        }
        $image->save($basePath);
        // $file->move(public_path('/uploads/'.$folder), $imageName);
        return $basePath;
    }
}

if(!function_exists('imagetoavif')) {
    function imagetoavif($image){
        // $image = match ($image->getExtension()) {
        //     'png' => imagecreatefrompng($image->),
        //      => imagecreatefromjpeg(),
        // };
        // $image = ;
        return imageavif($image);
    }
}
