<?php

namespace App\Services;

use App\Models\Product;
use App\Models\Purchase;
use App\Models\Setting;
use App\Models\User;

class PurchaseService {

    public $api = "https://wa.me";
    public Purchase $purchase;
    private $message = '';
    
    function create($data){
        $this->purchase = Purchase::create([
            ...$data,
            'product_id' => $data['product']
        ]);
        return $this;
    }

    function notify($message){
        $this->message = $message;

        $admins = User::isAdmin()->get();
        $purchase = $this->purchase;
        
        notify("New Transaction Alert")
            ->line($message)
            ->send($admins, ['mail']);
        
        return $this;
    }

    function send(Purchase $purchase = null){
        $phone = (new Setting)->whatsapp_phone->value;
        $purchase = $this->purchase ?? $purchase;
        $base_url = implode('/', [$this->api, $phone]);

        $params = http_build_query([
            'text' => $this->message
        ]);

        return implode('?', [$base_url, $params]);
    }

}