<?php

namespace App\Services;

use Exception;
use Illuminate\Support\Facades\Http;
use Illuminate\Http\Client\Response;
use Illuminate\Support\Facades\Date;

class ExchangeService {

    public $api;

    public function __construct() {
        $this->api = Http::baseUrl(env('EXCHANGE_RATES_API_URL'))->withQueryParameters(['access_key' => env('EXCHANGE_RATES_API_KEY')]);
    }

    function resolve(Response $response, $key = null){
        try {
            if($response->ok()){
                $data = $response->json();
                if(in_array('success', $data)){

                    if($data['success'] == true){
                        if($key) return [true, $data[$key]];
                        return [true, $data];
                    }

                    return [false, "Your request could not be completed at the moment."];
                }
                return [false, "Your request could not be completed at the moment."];
            }
        } catch (\Throwable $th) {
            return [false, "Your request could not be completed at the moment."];
        }

    }

    function currencies(){
        return $this->resolve($this->api->get('symbols'), 'symbols');
    }

    function latest($base = null, $symbols = null){
        $response = $this->api->get('latest', compact(['base', 'symbols']));
        return $this->resolve($response, 'rates');
    }

    function date($date, $base, $symbols){
        $response = $this->api->get(Date::parse($date)->format('Y-m-d'), compact(['base', 'symbols']));
        return $this->resolve($response, 'rates');
    }

    function convert($from, $to, $amount){
        $response = $this->api->get('convert', [
            'from' => $from,
            'to' => $to,
            'amount' => $amount
        ]);
        return $this->resolve($response);
    }

    function timeseries($start, $end, $base = null, $symbols = null){
        $response = $this->api->get('timeseries', compact(['start', 'end', 'base', 'symbols']));
        return $this->resolve($response, 'rates');
    }

}
