<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory, HasUuids;

    protected $fillable = ['name', 'slug', 'description', 'category_id', 'image', 'is_featured', 'meta_title', 'meta_description'];

    function posts(){
        return $this->hasMany(Blog::class, 'category_id');
    }
    
    function postsByCategory(){
        return $this->through('subCategories')->has('posts');
    }

    function parent(){
        return $this->belongsTo(Category::class, 'category_id');
    }

    function subCategories(){
        return $this->hasMany(Category::class, 'category_id');
    }

    function scopeIsParent(Builder $builder){
        $builder->whereNull('category_id');
    }
    
    function scopeIsChild(Builder $builder){
        $builder->whereHas('parent');
    }
}
