<?php

namespace App\Livewire\Exchange;

use App\Models\Currency;
use App\Services\ExchangeService;
use Livewire\Attributes\On;
use Livewire\Component;

class CurrencyRates extends Component {

    public $currencies;
    public $from;

    public $rates;
    public $displayRates = [];

    protected $listeners = [
        'currency:changed' => 'setRates'
    ];

    function mount(){
        $currencies = Currency::all();
        $this->currencies = $currencies;
        $this->from = session()->get('user_currency');
        $this->latestRates('USD');
        if($this->from) $this->latestRates($this->from);
    }

    #[On('currency:changed')]
    function setRates($from){
        $this->latestRates($from);
    }

    public function percentageDifference($oldValue, $newValue) {
        $difference = $newValue - $oldValue;
        $percentageDifference = ($difference / $oldValue) * 100;

        return $percentageDifference;
    }

    function latestRates($from){
        $currencies = $this->currencies->whereIn('symbol', ['USD', 'EUR', 'GBP', 'YEN', 'CAD', 'CNY'])->where('symbol', '!=', $from);
        $exchangeService = new ExchangeService();
        $today = now();
        $yesterday = now()->subDay();

        [$status, $todayRates] = $exchangeService->date($today, $from, $currencies->implode('symbol', ','));
        if(!$status) return;

        [$status, $yesterdayRates] = $exchangeService->date($yesterday, $from, $currencies->implode('symbol', ','));

        if(!$status) return;

        $this->rates = collect($todayRates)->map(function($rate, $index) use($yesterdayRates) {
            return [
                'today' => $rate,
                'yesterday' => $yesterdayRates[$index],
                'percent' => $this->percentageDifference($rate, $yesterdayRates[$index])
            ];
        });

        $this->displayRates = $this->rates->filter(fn($val, $key) => in_array($key, $currencies->pluck('symbol')->toArray()));
    }

    public function render(){
        return view('livewire.exchange.currency-rates');
    }
}
