<?php

namespace App\Livewire;

use App\Enums\Status;
use App\Models\Product;
use App\Services\PurchaseService;
use Livewire\Attributes\Layout;
use Livewire\Component;

#[Layout('layouts.guest', [
    'title' => "Gift Cards"
])]
class BuyGiftCards extends Component {
    
    public $products;

    public $product, $name, $phone, $email, $amount;
    public $type = 'buy';

    function mount(){
        $this->products = Product::where([
            'category' => 'giftcards',
            'status' => Status::PUBLISHED
        ])->get();

        $this->product = $this->products->count() > 0 ? $this->products[0]->id : null;
    }

    function purchase(){
        $validated = $this->validate([
            'product' => 'required|exists:products,id', 
            'name' => 'required|string|max:255',
            'phone' => 'required',
            'email' => 'nullable|email',
            'amount' => 'numeric|required',
            'type' => 'required|in:buy,sell'
        ]);

        $product = Product::find($this->product);
        $type = str($this->type)->headline();
        $amount = number_format($this->amount);

        $message = <<<MESSAGE
            Hi there, my name is $this->name.

            I just created a transaction on Moniest. The details are as follows:
            
            Name: $this->name
            Email Address: $this->email 
            Transaction Type: $type Gift Cards
            Currency: $product->name
            Amount: $$amount
        MESSAGE;
        
        $message = (new PurchaseService)->create($validated)->notify($message)->send();
        $this->redirect($message);
    }


    public function render()
    {
        return view('livewire.buy-gift-cards');
    }
}
