<?php

namespace App\Livewire\Blog;

use App\Library\Functions;
use App\Models\Blog;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Mustache_Engine;

#[Layout('layouts.guest', [
    'title' => "Blog Post"
])]
class BlogPost extends Component {

    public $blog;

    public $content = '';

    function mount(){
        $mustache = new Mustache_Engine();
        $this->content = $mustache->render($this->blog->render('content'), (new Functions)->templates());
    }

    public function render(){
        $relatedPosts = $this->blog->category()->posts()->isActive()->latest()->get();
        return view('livewire.blog.blog-post', [
            'trending' => Blog::orderBy('visits')->latest()->limit(3)->get(),
            'relatedPosts' => $relatedPosts
        ]);
    }
}
