<?php

namespace App\Http\Controllers;

use App\Library\Functions;
use App\Models\Blog;
use App\Models\Category;
use App\Models\Page;
use Illuminate\Http\Request;
use Mustache_Engine;

class PageController extends Controller
{

    function index(){
        $recentPosts = Blog::isPublished()->latest()->limit(3)->get();

        $categories = Category::isParent()->whereHas('postsByCategory')->get();

        return view('welcome', compact('recentPosts', 'categories'));
    }

    function buysell(){
        return view('buysell');
    }

    public function show(Request $request, $slug){
        if(!$page = Page::where('slug', $slug)->first()) {
            if($blog = Blog::where('slug', $slug)->first()) {

                return view('blog-post', [
                    'blog' => $blog,
                    'content' => (new Mustache_Engine)->render($blog->content, (new Functions)->templates()),
                    'trending' => Blog::orderBy('visits')->isPublished()->where('id', '!=', $blog->id)->latest()->limit(3)->get(),
                    'related' => $blog->category()->posts()->isPublished()
                                        ->where('id', '!=', $blog->id)
                                        ->latest()->orderBy('visits')->limit(4)->get()
                ]);
            }

            return to_route('home');
        }

        return view('custom-page', ['page' => $page]);
    }
}
