<?php

namespace App\Console\Commands;

use App\Enums\Status;
use App\Livewire\Blog\Blog;
use Illuminate\Console\Command;

class PublishScheduledPosts extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'posts:publish';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Publish Scheduled Posts';

    /**
     * Execute the console command.
     */
    public function handle() {
        Blog::where('published_at', '<=', now())->where('status', Status::SCHEDULED)->update([
            'status' => Status::PUBLISHED
        ]);
    }
}
