<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <?php echo $__env->make('layouts.partials.styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <link rel="shortcut icon" href="<?php echo e(asset('favicon.png')); ?>" type="image/x-icon">
    <title><?php echo e($title ?? ''); ?> - <?php echo e(env('APP_NAME')); ?></title>
    <meta name="keywords" content="monieroar nigerian currency to dollar, aboki dollar to naira today, dollar to naira bank rate today, dollar exchange rate today, foreign exchange rate today, dollar exchange rate, usd exchange rate, Currency Exchange Rate, gift cards, cryptocurrency, receive money from abroad" />
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <?php echo $setting->header_scripts->value; ?>

    <link rel="canonical" href="<?php echo e(request()->url()); ?>" />

    <?php echo $__env->yieldPushContent('meta'); ?>
</head>

<body>
    <div class="switch-theme-mode">
        <label id="switch" class="switch">
            <input type="checkbox" onchange="toggleTheme()" id="slider">
            <span class="slider round"></span>
        </label>
    </div>

    <div class="page-wrapper">
        <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo e($slot); ?>


        <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>

    <?php echo $__env->make('layouts.partials.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $setting->footer_scripts->value; ?>

</body>

</html>
<?php /**PATH /home/u907741724/domains/monieroar.com/public_html/resources/views/layouts/guest.blade.php ENDPATH**/ ?>