<?php

use App\Http\Controllers\FileController;
use App\Http\Controllers\MessagesController;
use App\Http\Controllers\PageController;
use App\Livewire\About;
use App\Livewire\Blog\Blog;
use App\Livewire\Blog\BlogCategory;
use App\Livewire\Blog\BlogPost;
use App\Livewire\BuyCrypto;
use App\Livewire\BuyGiftCards;
use App\Livewire\Charts;
use App\Livewire\Contact;
use App\Livewire\Converter;
use App\Livewire\DollarPayments;
use App\Livewire\RateAlerts;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::prefix('files')->group(function (){
    Route::post('upload', [FileController::class, 'upload'])->name('files.upload');
});

Route::get('/', [PageController::class, 'index'])->name('home');

Route::get('/converter', Converter::class)->name('convert');
Route::get('/charts', Charts::class)->name('charts');
Route::get('/rate-alerts', RateAlerts::class)->name('rate-alerts');

Route::prefix('buy-sell')->group(function(){
    Route::get('', [PageController::class, 'buysell'])->name('buysell');
    Route::get('crypto', BuyCrypto::class)->name('crypto');
    Route::get('giftcards', BuyGiftCards::class)->name('giftcards');
    Route::get('dollar-payments', DollarPayments::class)->name('dollar-payments');
});

Route::get('/about', About::class)->name('about');

Route::prefix('contact')->group(function(){
    Route::get('/', Contact::class)->name('contact');
    Route::post('/', [MessagesController::class, 'send'])->name('contact.send');
});

Route::prefix('blog')->group(function(){
    Route::get('', Blog::class)->name('blog');

    Route::prefix('{category:slug}')->group(function(){
        Route::get('', BlogCategory::class)->name('blog.category');
        Route::get('{child}', BlogCategory::class)->name('blog.category.child');
    });
});


Route::get('{page}', [PageController::class, 'show'])->name('page');

Route::prefix('{blog:slug}')->group(function(){
    Route::get('', BlogPost::class)->name('blog.details');
});

Route::fallback([PageController::class, 'index']);
