<div>
    @if ($base || $target)
        <section class="convert-wrap ptb-50">
            <div class="container">
                <div class="col-md-10 mx-auto">
                    <div class="row">
                        <div class="col-md-6">
                            @if ($base)
                                <div class="convert-box text-center">
                                    <div style="color: #0D47A1" class="bg-light p-3 ">
                                        <h5 class="mb-2">Convert {{$base['symbol']}} to {{$target['symbol']}}</h5>

                                        <div class="row">
                                            <div class="col-6 fs-6 fw-bold">{{$base['name']}}</div>
                                            <div class="col-6 fs-6 fw-bold">{{$target['name']}}</div>
                                        </div>
                                    </div>

                                    <div class="text-center">
                                        <div class="p-3">
                                            @forelse ($targetToBase as $value)
                                                <div class="row py-2">
                                                    <div class="col-6">{{number_format($value['step'])}} {{$base['symbol']}}</div>
                                                    <div class="col-6">{{number_format($value['amount'], 1, '.')}} {{$target['symbol']}}</div>
                                                </div>
                                            @empty
                                            @endforelse
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                        <div class="col-md-6">
                            @if ($target)
                                <div class="convert-box text-center">
                                    <div style="color: #0D47A1" class="bg-light p-3 ">
                                        <h5 class="mb-2">Convert {{$target['symbol']}} to {{$base['symbol']}}</h5>

                                        <div class="row">
                                            <div class="col-6 fs-6 fw-bold">{{$target['name']}}</div>
                                            <div class="col-6 fs-6 fw-bold">{{$base['name']}}</div>
                                        </div>
                                    </div>

                                    <div class="text-center">
                                        <div class="p-3">
                                            @forelse ($baseToTarget as $value)
                                                <div class="row py-2">
                                                    <div class="col-6">{{number_format($value['step'])}} {{$target['symbol']}}</div>
                                                    <div class="col-6">{{number_format($value['amount'], 1, '.')}} {{$base['symbol']}}</div>
                                                </div>
                                            @empty
                                            @endforelse
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif
</div>

