<div class="row align-items-center g-5">
    <div class="col-lg-6 order-lg-1 order-md-2 order-2">
        <div class="alert-content">
            <h2>Let Us Watch The Market For You</h2>
            <h5>Millions of people check our rates and send money with us everyday.</h5>
            <ul class="content-feature-list list-style">
                <li><i class="flaticon-checked"></i>See our low fees &amp; exchange rate in
                    real-time.</li>
                <li><i class="flaticon-checked"></i>Transparent delivery time so you can
                    move money fast.</li>
                <li><i class="flaticon-checked"></i>Sign up for a free personal or business
                    account in minutes.</li>
            </ul>
        </div>
    </div>
    <div class="col-lg-6 order-lg-2 order-md-2 order-1">
        <div class="alert-content">
            <form wire:submit='createRateAlert' class="d-flex flex-column">
                <div class="">
                    <h3>Track currency exchange rate</h3>
                </div>

                <p class="text-success">{{$success}}</p>

                <div class="row">
                    <div class="col-lg-6">
                        <div class="form-group">
                            <label for="country_from">From Currency</label>
                            <select wire:model='from' id="country_from">
                                @forelse ($currencies->isActive()->get() as $currency)
                                    <option value="{{$currency->symbol}}">{{$currency->symbol}} - {{$currency->name}}</option>
                                @empty
                                @endforelse
                            </select>
                            <x-input.error key="from" />
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="form-group">
                            <label for="currency_to">To Currency</label>
                            <select wire:model='to' id="country_to">
                                @forelse ($currencies->isActive()->get() as $currency)
                                <option value="{{$currency->symbol}}">{{$currency->symbol}} - {{$currency->name}}</option>
                                @empty
                                @endforelse
                            </select>
                            <x-input.error key="to" />
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label class="form-label">Name</label>
                    <input type="text" wire:model="name" class="form-control" placeholder="Name">
                    <x-input.error key="name" />
                </div>

                <div class="form-group">
                    <label class="form-label">Email Address</label>
                    <input type="text" wire:model="email" class="form-control" placeholder="Email Address">
                    <x-input.error key="email" />
                </div>

                <div class="form-group">
                    <label class="form-label">Frequency</label>
                    <select wire:model="frequency" id="" class="form-select">
                        <option >Daily</option>
                        <option >Weekly</option>
                    </select>
                    <x-input.error key="frequency" />
                </div>

                <div>
                    <button type="submit" class="btn style1 w-100">Subscribe <x-spinner wire:loading wire:trigger='createRateAlert' /></button>
                </div>
            </form>
        </div>
    </div>
</div>
