<div>
    <form wire:submit='exchange' class="convert-form " style="position: relative;">
        <div class="row">
            <div class="col-lg-3">
                <div class="form-group" >
                    <label for="currency">I'd Like To Exchange </label>
                    <div class="" style="position: relative;">
                        <span class="h-100 d-flex justify-content-center align-items-center" style="position: absolute; padding-left: 10px;">{{$from}}</span>
                        <x-input.currency :currency="$from" value="{{$amount}}" wire:model.blur='amount' style="padding-left: 50px;" id="currency" name="currency" />
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="form-group">
                    <label for="country_from">Country From</label>
                    <select name="from" wire:model.blur='from' id="from">
                        @forelse ($currencies as $currency)
                            <option value="{{$currency->symbol}}">{{$currency->symbol}} - {{$currency->name}}</option>
                        @empty
                        @endforelse
                    </select>
                </div>
            </div>
            <div class="text-center col-lg-1 d-flex justify-content-center">
                <span class="convert-icon" role="button" wire:click='swap' style="display: flex; align-items: center; justify-content: center;">
                    <i class="ri-arrow-left-right-line"></i>
                </span>
            </div>
            <div class="col-lg-4">
                <div class="form-group">
                    <label for="currency_to">Country To</label>
                    <select name="to" wire:model.blur='to' id="to">
                        @forelse ($currencies as $currency)
                            <option value="{{$currency->symbol}}">{{$currency->symbol}} - {{$currency->name}}</option>
                        @empty
                        @endforelse
                    </select>
                </div>
            </div>
        </div>
        <div class="mt-20 row align-items-center">
            @if ($result)
                <div class="mb-20">
                    <strong>{{$amount}} {{$fromCurrency->name}} =</strong>
                    <h2>{{number_format($result, 3, '.')}} {{$toCurrency->name}}</h2>
                    <p class="mb-0">1 {{$from}} = {{number_format($rate, 3, '.')}} {{$to}}</p>
                    <p>1 {{$to}} = {{number_format(1 / $rate, 3, '.')}} {{$from}}</p>
                </div>
            @endif
            <div class="col-xl-6 col-lg-8">
                <div class="converter-alert-text">
                    <i class="ri-error-warning-line"></i>
                    <small>We use mid-market rate for our converter. This is for international
                        purpose only. You won't recieve this rate when send money.</small>
                </div>
            </div>

            <div class="col-xl-6 col-lg-4 text-lg-end">
                <button  class="btn style1"> CONVERT <i class="ri-arrow-right-s-line"></i> <x-spinner wire:loading wire:target="exchange" /></button>
            </div>
        </div>
    </form>
</div>
