<div>
    @include('livewire.exchange.charts-js')

    <form action="#" class="convert-form" x-data="{
        options: options,
        chart: null,
        start: null,
        end: null,
        setDate: (startdate) => {
            const date = new Date();
            {{-- const startdate = date.setHours(newDate.getHours() - 12) --}}
            chart.zoomX(
                startdate.getTime(),
                date.getTime()
            )
        }
    }" x-init="
        chart = new ApexCharts($refs.charts, options);
        chart.render();
    ">
        <div class="row">
            <div class="col-lg-5">
                <div class="form-group">
                    <label for="country_from">Country From</label>
                    <select wire:model='from' id="country_from">
                        @forelse ($currencies as $currency)
                            <option value="{{$currency->symbol}}">{{$currency->symbol}} - {{$currency->name}}</option>
                        @empty
                        @endforelse
                    </select>
                </div>
            </div>
            <div class="col-lg-2 text-center">
                <span class="convert-icon mx-auto" role="button" wire:click='swap' style="display: flex; align-items: center; justify-content: center;"> <i class="ri-arrow-left-right-line"></i> </span>
            </div>
            <div class="col-lg-5">
                <div class="form-group">
                    <label for="currency_to">Country To</label>
                    <select wire:model='to' id="country_to">
                        @forelse ($currencies as $currency)
                            <option value="{{$currency->symbol}}">{{$currency->symbol}} - {{$currency->name}}</option>
                        @empty
                        @endforelse
                    </select>
                </div>
            </div>
        </div>
        <div class="row mt-20 align-items-center">
            <div class="col-xl-6 col-lg-8">
                <div class="converter-alert-text">
                    <i class="ri-error-warning-line"></i>
                    <p>We use mid-market rate for our converter. This is for international
                        purpose only. You won't recieve this rate when send money. <a
                            href="chart.html" class="link style1">Check send rates</a></p>
                </div>
            </div>
            <div class="col-xl-6 col-lg-4 text-lg-end">
                <a wire:click='setChart' class="btn style1" >VIEW CHARTS<i class="ri-arrow-right-s-line"></i></a>
            </div>
        </div>

        <div class="d-flex gap-2 my-5">
            <div>
                <button x-on:click="setDate(new Date().setHours(newDate.getHours() - 12))"  class="btn btn-sm btn-primary p-1 px-3 rounded-pill">12 hours</button>
            </div>
            <div>
                <button x-on:click="setDate(new Date().setDate(newDate.getDate() - 1))" class="btn btn-sm btn-primary p-1 px-3 rounded-pill">1 day</button>
            </div>
            <div>
                <button x-on:click="setDate(new Date().setDate(newDate.getDate() - 7))" class="btn btn-sm btn-primary p-1 px-3 rounded-pill">1 Week</button>
            </div>
            <div>
                <button x-on:click="setDate(new Date().setMonth(newDate.getMonth() - 1))" class="btn btn-sm btn-primary p-1 px-3 rounded-pill">1 Month</button>
            </div>
            <div>
                <button x-on:click="setDate(new Date().setYear(newDate.getYear() - 1))" class="btn btn-sm btn-primary p-1 px-3 rounded-pill">1 Year</button>
            </div>
            <div>
                <button x-on:click="setDate(new Date().setYear(newDate.getYear() - 1))" class="btn btn-sm btn-primary p-1 px-3 rounded-pill">2 Years</button>
            </div>
            <div>
                <button class="btn btn-sm btn-primary p-1 px-3 rounded-pill">5 Years</button>
            </div>
            <div>
                <button class="btn btn-sm btn-primary p-1 px-3 rounded-pill">10 Years</button>
            </div>
        </div>
        <div x-ref="charts"></div>
    </form>

</div>
