<div class="sidebar">
    <div class="sidebar-widget">
        <div class="search-box">
            <form action="{{route('blog')}}" class="form-group">
                <input type="search" name="search" placeholder="Search">
                <button type="submit">
                    <i class="ri-search-line"></i>
                </button>
            </form>
        </div>
    </div>

    @if ($categories->count() > 0)
        <div class="sidebar-widget">
            <div class="widget-title">
                <h4>Categories <span></span></h4>
            </div>
            <ul class="list-style category-box">
                @forelse ($categories->isParent()->limit(5)->get() as $category)
                    <li>
                        <a href="{{route('blog.category', ['category' => $category->slug])}}">
                            <i class="ri-arrow-right-line"></i>
                            {{$category->name}}
                        </a>
                    </li>
                @empty

                @endforelse
            </ul>
        </div>
    @endif

    <div class="sidebar-widget">
        <div class="widget-title">
            <h4>Trending Post <span></span></h4>
        </div>
        <div class="popular-post-widget">
            @forelse ($trending as $post)
                <div class="pp-post-item">
                    <a href="{{$post->route}}" class="pp-post-img">
                        <img src="{{$post->featured_image}}" alt="Image">
                    </a>
                    <div class="pp-post-info">
                        <span><i class="ri-calendar-event-line"></i>{{Date::parse($post->created_at)->format('jS M Y')}}</span>
                        <h6>
                            <a href="{{$post->route}}">
                                {{$post->title}}
                            </a>
                        </h6>
                    </div>
                </div>
            @empty

            @endforelse
        </div>
    </div>
    {{-- <div class="sidebar-widget">
        <div class="widget-title">
            <h4>Tags<span></span></h4>
        </div>
        <ul class="tag-list list-style">
            <li><a href="posts-by-tag.html">Exchange</a></li>
            <li><a href="posts-by-tag.html">Money</a></li>
            <li><a href="posts-by-tag.html">Currency</a></li>
            <li><a href="posts-by-tag.html">Risks</a></li>
            <li><a href="posts-by-tag.html">Paypal</a></li>
            <li><a href="posts-by-tag.html">Security</a></li>
            <li><a href="posts-by-tag.html">Business</a></li>
        </ul>
    </div> --}}
</div>
