<div class="content-wrapper">
    @forelse ($adverts->where('position', 'below_top_menu_bar')->get() as $advert)
        <div class="feature-wrap style1 py-3 bg-whisper">
            {!! $advert->content !!}
        </div>
    @empty
    @endforelse

    <div class="feature-wrap style1 pt-100 pb-75 bg-whisper">
        <div class="container">
            <div class="row">
                <div class="col-xl-6 offset-xl-3 col-lg-10 offset-lg-1">
                    <div class="section-title style1 text-center mb-40">
                        <span>Our Blog</span>
                        {{-- <h2>Get the latest finance/currency news and updates</h2> --}}
                    </div>
                </div>
            </div>
            <div class="row justify-content-center">
                @forelse ($categories as $category)
                    <div class="col-md-3 cols-6">
                        @include('livewire.blog.partials.category-item')
                    </div>
                @empty
                @endforelse
            </div>
        </div>
    </div>

    <div class="blog-wrap ptb-100">
        <div class="container">
            <div class="mb-5">
                <h3 class="mb-0">Latest Posts</h3>
                <p>Here are latest posts on financial insights and currency updates</p>
            </div>

            <div class="row row-cols-md-3 g-5 mb-5">
                @forelse ($posts as $post)
                    <div>
                        @include('livewire.blog.partials.blog-item', ['category' => $post->category])
                    </div>
                @empty
                @endforelse
            </div>

            {{$posts->onEachSide(2)->links('partials.paginator')}}
        </div>
    </div>

    @forelse ($categories as $category)
        <div class="blog-wrap ptb-100">
            <div class="container">
                <div class="mb-4">
                    <h4 class="mb-0"><a href="{{route('blog.category', ['category' => $category->slug])}}">{{$category->name}}</a></h4>
                    <p>{{$category->description}}</p>
                </div>

                <div class="row row-cols-md-3 g-5 mb-5">
                    @forelse ($category->postsByCategory()->isPublished()->limit(3)->get() as $post)
                        <div>
                            @include('livewire.blog.partials.blog-item')
                        </div>
                    @empty
                    @endforelse
                </div>

                <div class="text-center">
                    <a href="{{route('blog.category', ['category' => $category->slug])}}">
                        <button  class="btn style1">Load More</button>
                    </a>
                </div>
            </div>
        </div>
    @empty

    @endforelse

</div>
