<div class="content-wrapper">

    @forelse ($adverts->where('position', 'below_top_menu_bar')->get() as $advert)
        <div class="py-3 feature-wrap style1 bg-whisper">
            {!! $advert->content !!}
        </div>
    @empty
    @endforelse

    <div class="breadcrumb-wrap bg-f br-1">
        <div class="container">
            <div class="breadcrumb-title">
                <h2>{{$blog->title}}</h2>
                <ul class="breadcrumb-menu list-style">
                    <li><a href="{{route('home')}}">Home</a></li>
                    <li><a href="{{route('blog')}}">Blog</a></li>
                    <li>{{$blog->title}}</li>
                </ul>
            </div>
        </div>
    </div>


    <div class="blog-details-wrap ptb-100">
        <div class="container">
            <div class="row gx-5">
                <div class="col-xl-8 col-lg-12">
                    <article>
                        <div class="mt-0 post-img">
                            <img src="{{route('file.get', $blog->featured_image)}}" alt="Image">
                            <a href="{{route('blog.category', ['category' => $blog->category->slug])}}" class="post-cat">{{$blog->category->name}}</a>
                        </div>
                        <ul class="post-metainfo list-style">
                            <li><i class="ri-calendar-event-line"></i>{{Date::parse($blog->published_at)->format('jS F, Y')}}</li>
                            {{-- <li><i class="ri-message-2-line"></i>3 Comments</li> --}}
                        </ul>
                        <h2>{{$blog->title}}</h2>
                        <div class="post-para">
                            {!! $content !!}
                        </div>
                    </article>
                    <div class="post-meta-option">
                        <div class="row gx-0 align-items-center">
                            <div class="col-md-7 col-12">
                                <div class="post-tag">
                                    <span>Tags:</span>
                                    <ul class="tag-list style2 list-style">
                                        @forelse ($blog->tags as $tag)
                                            <li>{{$tag}}, </li>
                                        @empty
                                        @endforelse
                                    </ul>
                                </div>
                            </div>
                            <div class="col-md-5 col-12 text-md-end text-start">
                                <div class="post-share w-100">
                                    <span>Share:</span>
                                    <ul class="social-profile style1 list-style">
                                        <li>
                                            <a target="_blank" href="https://www.facebook.com/sharer/sharer.php?quote={{request()->fullURL()}}">
                                                <i class="ri-facebook-fill"></i>
                                            </a>
                                        </li>
                                        <li>
                                            <a target="_blank"  href="https://twitter.com/intent/tweet?text={{$blog->title}}url={{request()->fullURL()}}">
                                                <i class="ri-twitter-fill"></i>
                                            </a>
                                        </li>
                                        <li>
                                            <a target="_blank" href="https://www.linkedin.com/sharing/share-offsite/?url={{request()->fullURL()}}">
                                                <i class="ri-linkedin-fill"></i>
                                            </a>
                                        </li>
                                        <li>
                                            <a target="_blank" href="mailto:?body={{request()->fullURL()}}&subject={{$blog->title}}">
                                                <i class="ri-mail-fill"></i>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    {{-- <div class="post-author">
                        <div class="post-author-img">
                            <img src="assets/img/blog/author-1.jpg" alt="Image">
                        </div>
                        <div class="post-author-info">
                            <h4>Riayn Roman</h4>
                            <p>Claritas est etiam amet sinicus, qui sequitur lorem ipsum semet coui lectorum.
                                Lorem ipsum dolor voluptatem corporis blanditiis sadipscing elitr sed diam
                                nonumy eirmod amet sit lorem.</p>
                            <ul class="social-profile style1 list-style">
                                <li>
                                    <a target="_blank" href="https://facebook.com/">
                                        <i class="ri-facebook-fill"></i>
                                    </a>
                                </li>
                                <li>
                                    <a target="_blank" href="https://twitter.com/">
                                        <i class="ri-twitter-fill"></i>
                                    </a>
                                </li>
                                <li>
                                    <a target="_blank" href="https://linkedin.com/">
                                        <i class="ri-instagram-line"></i>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div> --}}

                </div>
                <div class="col-xl-4 col-lg-12">
                    @include('livewire.blog.partials.blog-sidebar')
                </div>
            </div>

            <div class="div">
                <div class="mb-5">
                    <h2>Related Posts</h2>
                </div>
                <div class="row row-cols-md-3">
                    @forelse ($relatedPosts as $post)
                        @include('livewire.blog.partials.blog-item', ['category' => $post->category])
                    @empty
                    @endforelse
                </div>
            </div>
        </div>
    </div>

</div>
