<div class="container">
    @forelse ($adverts->where('position', 'below_top_menu_bar')->get() as $advert)
        <div class="feature-wrap style1 py-3 bg-whisper">
            {!! $advert->content !!}
        </div>
    @empty
    @endforelse
</div>

<footer class="footer-wrap">
    <div class="container">
        <div class="row pt-100 pb-75">
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-6">
                <div class="footer-widget">
                    <a href="{{route('home')}}" class="footer-logo">
                        <img src="{{$setting->site_logo->value}}" style="max-height: 50px;" class="img-fluid" alt="Image">
                    </a>
                    <p class="comp-desc">
                        {{$setting->description->value}}
                    </p>
                    <ul class="social-profile style1 list-style">
                        <li>
                            <a target="_blank" href="https://facebook.com/">
                                <i class="ri-facebook-fill"></i>
                            </a>
                        </li>
                        <li>
                            <a target="_blank" href="https://twitter.com/">
                                <i class="ri-twitter-fill"></i>
                            </a>
                        </li>
                        <li>
                            <a target="_blank" href="https://instagram.com/">
                                <i class="ri-instagram-line"></i>
                            </a>
                        </li>
                        <li>
                            <a target="_blank" href="https://linkedin.com/">
                                <i class="ri-linkedin-fill"></i>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <div class="col-xl-2 col-lg-5 col-md-6 col-sm-6 pe-xl-4">
                <div class="footer-widget">
                    <h3 class="footer-widget-title">Quick Links</h3>
                    <ul class="footer-menu list-style">
                        <li>
                            <a href="{{route('home')}}" >
                                Home
                            </a>
                        </li>
                        <li>
                            <a href="{{route('about')}}" >
                                About Us
                            </a>
                        </li>
                        <li>
                            <a href="{{route('contact')}}" >
                                Contact Us
                            </a>
                        </li>
                        @foreach ($pages->isActive()->quickLinks()->get() as $page)
                            <li><a href="{{route('page', ['page' => $page->slug])}}">{{$page->title}}</a></li>
                        @endforeach
                    </ul>
                </div>
            </div>

            <div class="col-xl-2 col-lg-3 col-md-3 col-sm-6">
                <div class="footer-widget">
                    <h3 class="footer-widget-title">Resources</h3>
                    <ul class="footer-menu list-style">
                        <li>
                            <a href="{{route('convert')}}" >
                                Currency Converter
                            </a>
                        </li>
                        <li>
                            <a href="{{route('rate-alerts')}}" >
                                Rate Alerts
                            </a>
                        </li>
                        <li>
                            <a href="{{route('blog')}}" >
                                Blog
                            </a>
                        </li>
                        @foreach ($pages->isActive()->resources()->get() as $page)
                            <li><a href="{{route('page', ['page' => $page->slug])}}">{{$page->title}}</a></li>
                        @endforeach
                    </ul>
                </div>
            </div>

            <div class="col-xl-3 col-lg-7 col-md-6 col-sm-6">
                <div class="footer-widget">
                    <h3 class="footer-widget-title">Contact Us</h3>
                    <ul class="contact-info list-style">
                        {{-- <li>
                            <i class="ri-map-pin-fill"></i>
                            <h6>Location</h6>
                            <p>{{$setting->contact_address->value}}</p>
                        </li> --}}
                        <li>
                            <i class="ri-mail-open-fill"></i>
                            <h6>Email</h6>
                            <a href="mailto:{{$setting->site_email->value}}">{{$setting->site_email->value}}</a>
                        </li>
                        <li>
                            <i class="ri-phone-fill"></i>
                            <h6>Phone</h6>
                            <a href="tel:{{$setting->contact_phone->value}}">{{$setting->contact_phone->value}}</a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <p class="copyright-text"><i class="ri-copyright-line"></i> <span>{{now()->format('Y')}}</span>. All Rights
                    Reserved By <a href="{{route('home')}}" target="_blank">{{env('APP_NAME')}}</a></p>
            </div>
        </div>
    </div>
</footer>
