<x-guest-layout :title="$blog->title">
    <div class="content-wrapper">
        @push('meta')
            <meta name="description" content="{{$blog->description}}">
            <meta name="keywords" content="@forelse ($blog->tags as $tag){{$tag}},@empty @endforelse">
            <meta property="og:image"  content="{{$blog->featured_image}}">
            <meta name="twitter:image" content="{{$blog->featured_image}}">

            <meta name='description'         content='{{$blog->description}}'>
            <meta property='og:description'  content='{{$blog->description}}'>
            <meta name='twitter:description' content='{{$blog->description}}'>

            <meta property='og:title'  content='{{$blog->title}}'>
            <meta name='twitter:title' content='{{$blog->title}}'>
        @endpush

        @forelse ($adverts->where('position', 'below_top_menu_bar')->get() as $advert)
            <div class="feature-wrap style1 pt-100 pb-75 bg-whisper">
                {!! $advert->content !!}
            </div>
        @empty
        @endforelse


        @forelse ($adverts->where('position', 'blog_post_top_bar')->get() as $advert)
            <div class="feature-wrap style1 pt-50 pb-75 bg-whisper">
                {!! $advert->content !!}
            </div>
        @empty
        @endforelse

        <div class="blog-details-wrap ptb-100">
            <div class="container">
                <div class="row gx-5 mb-5">
                    <div class="col-xl-8 col-lg-12">
                        <article>
                            {{-- <div class="mt-0 post-img">
                                <img src="{{$blog->featured_image}}" alt="Image">
                                <a href="{{route('blog.category', ['category' => $blog->category?->slug])}}" class="post-cat">{{$blog->category?->name}}</a>
                            </div> --}}
                            <h1>{{$blog->title}}</h1>


                            <ul class="post-metainfo list-style pt-0 mt-0">
                                <li><i class="ri-calendar-event-line"></i>{{Date::parse($blog->published_at ?? $blog->created_at)->format('jS F, Y h:i A')}}</li>
                                <li><i class="bi bi-clock"></i>{{Date::parse($blog->published_at ?? $blog->created_at)->diffForHumans()}}</li>
                                <li><i class="ri-user-2-line"></i>{{$blog->author?->fullname}}</li>
                            </ul>

                            <style>
                                .post-para a{
                                    color: red;
                                }
                            </style>

                            <div class="post-para">
                                {!! $content !!}
                            </div>
                        </article>
                        <div class="post-meta-option">
                            <div class="row gx-0 align-items-center">
                                <div class="col-md-7 col-12">
                                    <div class="post-tag">
                                        {{-- <span>Tags:</span>
                                            <ul class="tag-list style2 list-style">
                                                @forelse ($blog->tags as $tag)
                                                    <li><a href="{{route('blog.category.child', [
                                                        'category' => $blog->category?->parent?->slug ?? '',
                                                        'child' => $blog?->category->slug,
                                                        'tag' => $tag
                                                    ])}}">{{$tag}},</a> </li>
                                                @empty
                                                @endforelse
                                            </ul>
                                        --}}
                                    </div>
                                </div>
                                <div class="col-md-5 col-12 text-md-end text-start">
                                    <div class="post-share w-100">
                                        <span>Share:</span>
                                        <ul class="social-profile style1 list-style">
                                            <li>
                                                <a target="_blank" href="https://www.facebook.com/sharer/sharer.php?quote={{request()->fullURL()}}">
                                                    <i class="ri-facebook-fill"></i>
                                                </a>
                                            </li>
                                            <li>
                                                <a target="_blank"  href="https://twitter.com/intent/tweet?text={{$blog->title}}url={{request()->fullURL()}}">
                                                    <i class="ri-twitter-fill"></i>
                                                </a>
                                            </li>
                                            <li>
                                                <a target="_blank" href="https://www.linkedin.com/sharing/share-offsite/?url={{request()->fullURL()}}">
                                                    <i class="ri-linkedin-fill"></i>
                                                </a>
                                            </li>
                                            <li>
                                                <a target="_blank" href="mailto:?body={{request()->fullURL()}}&subject={{$blog->title}}">
                                                    <i class="ri-mail-fill"></i>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>

                        @if($blog->author)
                             <div class="post-author">
                                <div class="post-author-img">
                                    <img src="{{asset('storage'.$blog->author->avatar)}}" alt="Image">
                                </div>
                                <div class="post-author-info">
                                    <h4>{{$blog->author->fullname}}</h4>
                                    <p style="white-space: pre-wrap;">{{$blog->author->description}}</p>
                                    <ul class="social-profile style1 list-style">
                                        <li>
                                            <a target="_blank" href="{{$blog->author->facebook}}">
                                                <i class="ri-facebook-fill"></i>
                                            </a>
                                        </li>
                                        <li>
                                            <a target="_blank" href="{{$blog->author->twitter}}">
                                                <i class="ri-twitter-fill"></i>
                                            </a>
                                        </li>
                                        <li>
                                            <a target="_blank" href="{{$blog->author->linkedin}}">
                                                <i class="ri-linkedin-line"></i>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        @endif
                    </div>
                    <div class="col-xl-4 col-lg-12">
                        @include('livewire.blog.partials.blog-sidebar')
                    </div>
                </div>

                <div class="div">
                    <div class="mb-5">
                        <h3>Related Posts</h3>
                    </div>

                    <div class="row row-cols-md-3">
                        @forelse ($related as $post)
                            <div>
                                @include('livewire.blog.partials.blog-item')
                            </div>
                        @empty
                        @endforelse
                    </div>
                </div>
            </div>
        </div>

    </div>

</x-guest-layout>
