<?php

namespace App\Models;

use App\Enums\PagePositions;
use App\Traits\HasStatus;
use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Page extends Model
{
    use HasFactory, HasUuids, HasStatus;

    protected $fillable = ['title', 'slug', 'content', 'image', 'tags', 'description', 'position'];

    protected $casts = [
        'position' => PagePositions::class,
        'tags' => 'array'
    ];

    function scopeTopBar($query){
        $query->where('position', PagePositions::TOP_BAR);
    }

    function scopeResources($query) {
        $query->where('position', PagePositions::RESOURCES);
    }

    function scopeQuickLinks($query) {
        $query->where('position', PagePositions::QUICK_LINKS);
    }

    function scopeMainMenu($query) {
        $query->where('position', PagePositions::MAIN_MENU);
    }

}
