<?php

namespace App\Livewire\Exchange;

use Livewire\Attributes\On;
use Livewire\Component;

class RateAmounts extends Component {

    private $steps = [1, 20, 50, 100, 200, 500, 1000, 2000, 5000, 10000]; 

    public $baseToTarget = [], $targetToBase = []; 

    public $base, $target;

    public $from;
    public $to;

    #[On('rate:updated')]
    function setRates($data){
        [$from, $to, $rate] = $data;

        $this->base = $from;
        $this->target = $to;

        $steps = collect($this->steps);

        $this->baseToTarget = $steps->map(fn($item) => [
            'step' => $item,
            'amount' => $item * $rate
        ])->toArray();

        $this->targetToBase = $steps->map(fn($item) => [
            'step' => $item,
            'amount' => $item * (1 / $rate)
        ])->toArray();
    }

    public function render()
    {
        return view('livewire.exchange.rate-amounts');
    }
}
