<?php

namespace App\Livewire\Exchange;

use App\Models\RateAlert;
use Livewire\Component;

class RateAlerts extends Component {

    public $from = 'USD', $to = "EUR", $name, $email, $frequency = 'Daily';
    public $send_marketing_info = false;
    public $success;

    function createRateAlert(){
        $validated = $this->validate([
            'from' => 'required|string|exists:currencies,symbol',
            'to' => 'required|string|exists:currencies,symbol',
            'name' => 'required|string',
            'email' => 'required|string|email',
            'frequency' => 'required|string|in:Daily,Weekly',
            'send_marketing_info' => 'required|boolean',
        ]);

        RateAlert::create($validated);

        $this->reset();
        $this->success = "Your subscription was successful!";
    }

    public function render()
    {
        return view('livewire.exchange.rate-alerts');
    }
}
