<?php

namespace App\Livewire\Exchange;

use App\Models\Currency;
use Livewire\Attributes\Url;
use App\Services\ExchangeService;
use Livewire\Component;

class Converter extends Component
{
    #[Url]
    public $from = "USD";

    #[Url]
    public $to;

    #[Url]
    public $amount = 1;

    public Currency | null $fromCurrency = null;
    public Currency | null $toCurrency = null;

    public $currencies;

    public $result = null;
    public $rate = null;

    function mount(){
        $this->currencies = Currency::isActive()->get();
        $this->to = session('user_currency') ?? "GBP";
        
        $this->fromCurrency = Currency::where('symbol', $this->from)->first();
        $this->toCurrency = Currency::where('symbol', $this->to)->first();

        if($this->amount && $this->from && $this->to) $this->exchange();
    }

    function swap(){
        $from = $this->from;
        $to = $this->to;
        $this->to = $from;
        $this->from = $to;

        if($this->amount) $this->exchange();
    }

    function exchange(){
        $this->validate([
            'from' => 'required|string',
            'to' => 'required|string',
            'amount' => 'required|numeric'
        ]);
        
        $this->dispatch('currency:changed', from: $this->from);
        $this->fromCurrency = Currency::where('symbol', $this->from)->first();
        $this->toCurrency = Currency::where('symbol', $this->to)->first();

        $exchangeService = app(ExchangeService::class);
        [$status, $data] = $exchangeService->convert($this->from, $this->to, $this->amount);
        
        if($status) {
            $this->result = $data['result'];
            $this->rate = $data['info']['rate'];
        }

        $this->dispatch('rate:updated', data: [$this->fromCurrency, $this->toCurrency, $this->rate]);
    }

    public function updated($name){
        $this->exchange();
    }

    public function render()
    {
        return view('livewire.exchange.converter');
    }
}
