<?php

namespace App\Livewire;

use App\Models\Product;
use App\Services\PurchaseService;
use Livewire\Component;
use Livewire\Attributes\Layout;

#[Layout('layouts.guest', [
    'title' => "Make US Dollar payments"
])]
class DollarPayments extends Component {
    public $products;

    public $product, $name, $phone, $email, $amount;
    public $type = 'buy';

    function mount(){
        $this->products = Product::where('category', 'dollar_payments')->get();
    }

    function purchase() {
        $validated = $this->validate([
            'product' => 'required|exists:products,id', 
            'name' => 'required|string|max:255',
            'phone' => 'required|phone',
            'email' => 'nullable|email',
            'amount' => 'numeric|required',
            'type' => 'required|in:buy,sell'
        ]);

        $product = Product::find($this->product);
        $type = str($this->type)->headline();
        $amount = number_format($this->amount);

        $message = <<<MESSAGE
            Hi there, my name is $this->name.

            I just created a transaction on Moniest. The details are as follows:
            
            Name: $this->name
            Email Address: $this->email 
            Narration: $product->name Payments
            Transaction Type: $type Payments
            Amount: $$amount
        MESSAGE;
        
        $message = (new PurchaseService)->create($validated)->notify($message)->send();
        $this->redirect($message);
    }

    
    public function render()
    {
        return view('livewire.dollar-payments');
    }
}
