<?php

namespace App\Livewire;

use App\Enums\Status;
use App\Models\Product;
use App\Services\PurchaseService;
use Illuminate\Support\Facades\URL;
use Livewire\Attributes\Layout;
use Livewire\Component;

#[Layout('layouts.guest', [
    'title' => "Buy and Sell Cryptocurrencies"
])]
class BuyCrypto extends Component {

    public $products;

    public $product, $name, $phone, $email, $amount;
    public $type = 'buy';

    function mount(){
        $this->products = Product::where([
            'category' => 'crypto',
            'status' => Status::PUBLISHED
        ])->get();
        $this->product = $this->products->count() > 0 ? $this->products[0]->id : null;
    }

    function purchase(){
        $validated = $this->validate([
            'product' => 'required|exists:products,id', 
            'name' => 'required|string|max:255',
            'phone' => 'required',
            'email' => 'required|email',
            'amount' => 'numeric|required',
            'type' => 'required|in:buy,sell'
        ]);

        $product = Product::find($this->product);

        $type = str($this->type)->headline();
        $amount = number_format($this->amount);

        $message = <<<MESSAGE
            Hi there, my name is $this->name.

            I just created a transaction on Moniest. The details are as follows:
            
            Name: $this->name
            Email Address: $this->email 
            Transaction Type: $type Cryptocurrency
            Currency: $product->name
            Amount: $amount $product->name
        MESSAGE;

        $message = (new PurchaseService)->create($validated)->notify($message)->send();
        $this->redirect($message);
    }

    public function render() {
        return view('livewire.buy-crypto');
    }
}
