<?php

namespace App\Livewire\Blog;

use App\Enums\Status;
use App\Models\Blog;
use App\Models\Category;
use Livewire\Attributes\Layout;
use Livewire\Component;

#[Layout('layouts.guest')]
class BlogCategory extends Component {

    public Category $category;
    public $child = null;

    function mount(){
        $this->category = $this->child ? Category::where('slug', $this->child)->first() : $this->category;
        if(!$this->category) abort(404);
    }

    public function render() {
        $allPosts = !$this->category->parent ? $this->category->postsByCategory()->latest() : $this->category->posts()->latest();
        $posts = $allPosts->isPublished()->paginate();

        $featuredPosts = $allPosts->isPublished()->where('blogs.is_featured', true)->limit(6)->get();
        $categories = $this->category->subCategories()->whereHas('posts', fn($query) => $query->isPublished())->get();

        return view('livewire.blog.blog-category', compact('categories', 'posts', 'featuredPosts'))
                        ->title($this->category->name);
    }

}
