<?php

namespace App\Livewire\Blog;

use App\Models\Blog as ModelsBlog;
use App\Models\Category;
use Livewire\Attributes\Layout;
use Livewire\Attributes\Url;
use Livewire\Component;
use Livewire\WithPagination;

#[Layout('layouts.guest', [
    'title' => "Blog"
])]
class Blog extends Component {
    use WithPagination;

    public Category $category;

    #[Url]
    public $search;

    #[Url]
    public $tag;

    function mount(){

    }

    public function render() {
        $posts = ModelsBlog::when($this->search, function($query, $keyword){
            $query->where('title', 'LIKE', "%$keyword%");
        })->when($this->tag, function($query, $tag){
            $query->where('tags', 'LIKE', "%$tag%")->where('description', 'LIKE', "%$tag%");
        })->latest()->paginate();

        $trending = ModelsBlog::isPublished()->orderBy('visits')
                            ->limit(6)->get();

        $categories = Category::isParent()->whereHas('postsByCategory')->get();

        return $this->search ? view('livewire.blog.blog-search', ['posts' => $posts]) : view('livewire.blog.blog', compact('posts', 'trending', 'categories'));
    }
}
