<?php

namespace App\Http\Middleware;

use App\Models\Currency;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Symfony\Component\HttpFoundation\Response;

class CheckUserLocation
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response {
        $ipaddress = $request->ip();

        if(session()->get('user_currency')) return $next($request);

        try {
            $req = Http::get(env('LOCATION_API').$ipaddress);
            $data = $req->json();

            if($req->ok() && $data['status'] == 'success'){
                $this->setCountry($data['country']);
            }else{
                $firstCountry = Currency::first();
                $this->setCountry($firstCountry->symbol);
            }
            
        } catch (\Throwable $th) { }

        return $next($request);
    }

    public function setCountry($country){
        $currency = Currency::where('name', 'LIKE', "%$country%")->first();
        session([
            'user_currency' => $currency->symbol ?? 'GBP',
            'country' => $country,
            'currency' => $currency->id
        ]);
    }

}
