<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Gd\Driver;
use Intervention\Image\ImageManager;

class FileController extends Controller
{
    function index($path){
        return Storage::get($path);
    }

    function upload(Request $request){
        $request->validate([
            'upload' => 'required|image'
        ]);

        $file = $request->file("upload");

        $path = upload($file, pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME));

        return response()->json([
            'url' => asset($path)
        ]);
    }
}
