<?php

namespace App\Filament\Resources;

use App\Enums\Roles;
use App\Enums\Status;
use App\Filament\Resources\UserResource\Pages;
use App\Filament\Resources\UserResource\RelationManagers;
use App\Models\User;
use Filament\Forms;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Columns\Column;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Illuminate\Support\Facades\Hash;

class UserResource extends Resource
{
    protected static ?string $model = User::class;

    protected static ?string $navigationIcon = 'heroicon-o-users';
    protected static ?string $navigationLabel = 'Admins';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('firstname')
                    ->required()
                    ->placeholder('First Name')
                    ->maxLength(255),
                Forms\Components\TextInput::make('lastname')
                    ->required()
                    ->placeholder('Last Name')
                    ->maxLength(255),
                Forms\Components\TextInput::make('email')
                    ->email()
                    ->placeholder('Email Address')
                    ->required()
                    ->maxLength(255),
                Textarea::make('description')
                    ->placeholder('Bio Description')
                    ->columnSpanFull(),
                TextInput::make('facebook')
                    ->placeholder('Facebook URL')
                    ->url()
                    ->columnSpan(1),
                TextInput::make('twitter')
                    ->label('X (formerly Twitter)')
                    ->placeholder('Twitter URL')
                    ->url()
                    ->columnSpan(1),
                TextInput::make('instagram')
                    ->label('Instagram')
                    ->placeholder('Instagram URL')
                    ->url()
                    ->columnSpan(1),
                TextInput::make('linkedin')
                    ->label('Linked In')
                    ->placeholder('LinkedIn URL')
                    ->url()
                    ->columnSpan(1),
                Forms\Components\Select::make('role')
                    ->options([
                        Roles::WRITER->value => Roles::WRITER->value,
                        Roles::EDITOR->value => Roles::EDITOR->value,
                        Roles::ADMIN->value => Roles::ADMIN->value,
                        Roles::SUPERADMIN->value => Roles::SUPERADMIN->value,
                    ])
                    ->required(),
                Forms\Components\TextInput::make('password')
                    ->password()
                    ->dehydrateStateUsing(fn ($state) => Hash::make($state))
                    ->dehydrated(fn ($state) => filled($state))
                    ->placeholder('Password')
                    ->nullable()
                    ->maxLength(255),
                Forms\Components\Select::make('status')
                    ->options([
                        Status::ACTIVE->value => Status::ACTIVE->value,
                        Status::INACTIVE->value => Status::INACTIVE->value,
                    ])
                    ->required(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('firstname')
                    ->searchable(),
                Tables\Columns\TextColumn::make('lastname')
                    ->searchable(),
                Tables\Columns\TextColumn::make('role')
                    ->searchable(),
                Tables\Columns\TextColumn::make('email')
                    ->searchable(),
                Tables\Columns\TextColumn::make('status')
                    ->searchable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListUsers::route('/'),
            'create' => Pages\CreateUser::route('/create'),
            'view' => Pages\ViewUser::route('/{record}'),
            'edit' => Pages\EditUser::route('/{record}/edit'),
        ];
    }
}
